
///////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL SEMICONDUCTOR SYSTEMS - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   MSG1208.C - Message 1208 Processing
// 
//
//   DESCRIPTION
//
//   Functions to decode, build, and display Zodiac 1208 messages.
//
//
//   REVISION HISTORY
//
//   $Log:   V:\Projects\Labmon\Source\Archives\MSG1208.C_V  $
//   
//      Rev 1.15   09 Nov 1998 10:47:56   phungh
//   labmon51: Fix file logging and missing
//   logged data bugs.  Changes made to the 
//   "Pause" variable ( 1 -> 0 ) to allow main
//   loop continue.  Move the "write to file"
//   code portion out of the interrupt handler
//   so that data is not missed because of time
//   spent too long in the interrupt handler
//   
//      Rev 1.1   Jul 09 1997 10:44:52   COLEJ
//    
//   
//      Rev 1.0   25 Feb 1997 15:10:52   wladmin
//   Initial checking
//   
//
////////////////////////////////////////////////////////////////////////////////

#include <string.h>

#include "gentypes.h"
#include "gencons.h"
#include "ztypes.h"
#include "zcons.h"   
#include "util.h" 
#include "display.h"   

////////////////////////////////////////////////////////////////////////////////
//   
//   Decode a Zodiac 1208 message from the ZMsgBuf.
//
void Dec1208(tMSGBUF *ZMsgBuf, tMSG1208 *Msg)
{  
   GetBit(&InitModeData.TimingMode         , ZMsgBuf, 7,0);  // 1=timing mode used
   GetBit(&InitModeData.SelfSurveyMode     , ZMsgBuf, 7,1);  // 1=self survey mode used
}

////////////////////////////////////////////////////////////////////////////////
//   
//   Build a Zodiac 1208 message in the ZMsgBuf. 
//
void Bld1208(tMSGBUF *ZMsgBuf, tMSG1208 *Msg)
{
   // copy message into buffer
   memcpy(((tSHORT *) ZMsgBuf)+5, Msg, sizeof(*Msg));          

   // build the header in the buffer
   PutShort  (0x81FF                  , ZMsgBuf, 1);    // message preamble
   PutShort  (1208                    , ZMsgBuf, 2);    // message number
   PutShort  (12                      , ZMsgBuf, 3);    // message length
   PutShort  (ANREQ                   , ZMsgBuf, 4);    // message ack/nack request
   
   // poke bits into the packed words in the buffer
   PutBit(InitModeData.TimingMode           , ZMsgBuf, 7,0);  // 1=timing mode used
   PutBit(InitModeData.SelfSurveyMode       , ZMsgBuf, 7,1);  // 1=self survey mode used
}
